/*
 * Decompiled with CFR 0.152.
 */
package net.n3.nanoxml;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import net.n3.nanoxml.IXMLElement;
import net.n3.nanoxml.XMLAttribute;

public class XMLElement
implements Serializable,
IXMLElement {
    private IXMLElement parent;
    private Vector attributes = new Vector();
    private Vector children = new Vector(8);
    private String name;
    private String fullName;
    private String namespace;
    private String content;
    private String systemID;
    private int lineNr;

    public XMLElement() {
        this(null, null, null, -1);
    }

    public XMLElement(String fullName) {
        this(fullName, null, null, -1);
    }

    public XMLElement(String fullName, String systemID, int lineNr) {
        this(fullName, null, systemID, lineNr);
    }

    public XMLElement(String fullName, String namespace, String systemID, int lineNr) {
        int index;
        this.fullName = fullName;
        this.name = namespace == null ? fullName : ((index = fullName.indexOf(58)) >= 0 ? fullName.substring(index + 1) : fullName);
        this.namespace = namespace;
        this.content = null;
        this.lineNr = lineNr;
        this.systemID = systemID;
        this.parent = null;
    }

    public IXMLElement createElement(String fullName, String systemID, int lineNr) {
        return new XMLElement(fullName, systemID, lineNr);
    }

    public IXMLElement createElement(String fullName, String namespace, String systemID, int lineNr) {
        return new XMLElement(fullName, namespace, systemID, lineNr);
    }

    protected void finalize() throws Throwable {
        this.attributes.clear();
        this.attributes = null;
        this.children = null;
        this.fullName = null;
        this.name = null;
        this.namespace = null;
        this.content = null;
        this.systemID = null;
        this.parent = null;
        super.finalize();
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void addChild(IXMLElement child) {
        IXMLElement lastChild;
        if (child == null) {
            throw new IllegalArgumentException("child must not be null");
        }
        if (child.getName() == null && !this.children.isEmpty() && (lastChild = (IXMLElement)this.children.lastElement()).getName() == null) {
            lastChild.setContent(lastChild.getContent() + child.getContent());
            return;
        }
        ((XMLElement)child).parent = this;
        this.children.addElement(child);
    }

    public void removeChildAtIndex(int index) {
        this.children.removeElementAt(index);
    }

    public Enumeration enumerateChildren() {
        return this.children.elements();
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public int getChildrenCount() {
        return this.children.size();
    }

    public IXMLElement getChildAtIndex(int index) throws ArrayIndexOutOfBoundsException {
        return (IXMLElement)this.children.elementAt(index);
    }

    private XMLAttribute findAttribute(String fullName) {
        Enumeration enumeration = this.attributes.elements();
        while (enumeration.hasMoreElements()) {
            XMLAttribute attr = (XMLAttribute)enumeration.nextElement();
            if (!attr.getFullName().equals(fullName)) continue;
            return attr;
        }
        return null;
    }

    private XMLAttribute findAttribute(String name, String namespace) {
        Enumeration enumeration = this.attributes.elements();
        while (enumeration.hasMoreElements()) {
            XMLAttribute attr = (XMLAttribute)enumeration.nextElement();
            boolean found = attr.getName().equals(name);
            found = namespace == null ? (found &= attr.getNamespace() == null) : (found &= namespace.equals(attr.getNamespace()));
            if (!found) continue;
            return attr;
        }
        return null;
    }

    public int getAttributeCount() {
        return this.attributes.size();
    }

    public String getAttribute(String name, String defaultValue) {
        XMLAttribute attr = this.findAttribute(name);
        if (attr == null) {
            return defaultValue;
        }
        return attr.getValue();
    }

    public String getAttribute(String name, String namespace, String defaultValue) {
        XMLAttribute attr = this.findAttribute(name, namespace);
        if (attr == null) {
            return defaultValue;
        }
        return attr.getValue();
    }

    public int getAttribute(String name, int defaultValue) {
        String value = this.getAttribute(name, Integer.toString(defaultValue));
        return Integer.parseInt(value);
    }

    public String getAttributeNamespace(String name) {
        XMLAttribute attr = this.findAttribute(name);
        if (attr == null) {
            return null;
        }
        return attr.getNamespace();
    }

    public String getAttributeType(String name, String namespace) {
        XMLAttribute attr = this.findAttribute(name, namespace);
        if (attr == null) {
            return null;
        }
        return attr.getType();
    }

    public void setAttribute(String name, String value) {
        XMLAttribute attr = this.findAttribute(name);
        if (attr == null) {
            attr = new XMLAttribute(name, name, null, value, "CDATA");
            this.attributes.addElement(attr);
        } else {
            attr.setValue(value);
        }
    }

    public void setAttribute(String fullName, String namespace, String value) {
        int index = fullName.indexOf(58);
        String name = fullName.substring(index + 1);
        XMLAttribute attr = this.findAttribute(name, namespace);
        if (attr == null) {
            attr = new XMLAttribute(fullName, name, namespace, value, "CDATA");
            this.attributes.addElement(attr);
        } else {
            attr.setValue(value);
        }
    }

    public Enumeration enumerateAttributeNames() {
        Vector<String> result = new Vector<String>();
        Enumeration enumeration = this.attributes.elements();
        while (enumeration.hasMoreElements()) {
            XMLAttribute attr = (XMLAttribute)enumeration.nextElement();
            result.addElement(attr.getFullName());
        }
        return result.elements();
    }

    public boolean hasAttribute(String name) {
        return this.findAttribute(name) != null;
    }

    public boolean hasAttribute(String name, String namespace) {
        return this.findAttribute(name, namespace) != null;
    }

    public String getSystemID() {
        return this.systemID;
    }

    public int getLineNr() {
        return this.lineNr;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public boolean equals(Object rawElement) {
        try {
            return this.equalsXMLElement((IXMLElement)rawElement);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public boolean equalsXMLElement(IXMLElement elt) {
        if (!this.name.equals(elt.getName())) {
            return false;
        }
        if (this.attributes.size() != elt.getAttributeCount()) {
            return false;
        }
        Enumeration enumeration = this.attributes.elements();
        while (enumeration.hasMoreElements()) {
            XMLAttribute attr = (XMLAttribute)enumeration.nextElement();
            if (!elt.hasAttribute(attr.getName(), attr.getNamespace())) {
                return false;
            }
            String value = elt.getAttribute(attr.getName(), attr.getNamespace(), null);
            if (!attr.getValue().equals(value)) {
                return false;
            }
            String type = elt.getAttributeType(attr.getName(), attr.getNamespace());
            if (attr.getType().equals(type)) continue;
            return false;
        }
        if (this.children.size() != elt.getChildrenCount()) {
            return false;
        }
        int i = 0;
        while (i < this.children.size()) {
            IXMLElement child2;
            IXMLElement child1 = this.getChildAtIndex(i);
            if (!child1.equalsXMLElement(child2 = elt.getChildAtIndex(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

