/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.application;

import edu.colorado.phet.common.phetcommon.application.PhetPersistenceDir;
import edu.colorado.phet.common.phetcommon.util.AbstractPropertiesFile;
import java.io.File;
import java.security.AccessControlException;

public class SessionCounter {
    private static SessionCounter instance;
    private final String project;
    private final String simulation;
    private final SessionCountsFile file;

    private SessionCounter(String string, String string2) throws AccessControlException {
        this.project = string;
        this.simulation = string2;
        this.file = new SessionCountsFile();
    }

    public static synchronized SessionCounter initInstance(String string, String string2) {
        if (instance != null) {
            throw new RuntimeException("SessionCounter is already initialized");
        }
        try {
            instance = new SessionCounter(string, string2);
        }
        catch (AccessControlException accessControlException) {
            instance = null;
            System.out.println("SessionCounter: cannot create instance, no permissions");
        }
        return instance;
    }

    public static synchronized SessionCounter getInstance() {
        return instance;
    }

    public synchronized void incrementCounts() {
        this.file.setCount(this.project, this.simulation, this.file.getCount(this.project, this.simulation) + 1);
        this.file.setCountSince(this.project, this.simulation, this.file.getCountSince(this.project, this.simulation) + 1);
        this.file.setTotal(this.getTotal() + 1);
    }

    public synchronized void decrementCounts() {
        this.file.setCount(this.project, this.simulation, Math.max(0, this.file.getCount(this.project, this.simulation) - 1));
        this.file.setCountSince(this.project, this.simulation, Math.max(0, this.file.getCountSince(this.project, this.simulation) - 1));
        this.file.setTotal(Math.max(0, this.getTotal() - 1));
    }

    public synchronized void resetCountSince() {
        this.file.setCountSince(this.project, this.simulation, 0);
    }

    public synchronized int getCount() {
        return this.file.getCount(this.project, this.simulation);
    }

    public synchronized int getTotal() {
        return this.file.getTotal();
    }

    public synchronized int getCountSince() {
        return this.file.getCountSince(this.project, this.simulation);
    }

    public synchronized void clear() {
        if (!this.file.delete()) {
            this.file.deleteOnExit();
        }
    }

    private static class SessionCountsFile
    extends AbstractPropertiesFile {
        private static String getCountKey(String string, String string2) {
            return string + "." + string2 + ".count";
        }

        private static String getSinceKey(String string, String string2) {
            return string + "." + string2 + ".since";
        }

        public SessionCountsFile() throws AccessControlException {
            super(new File(new PhetPersistenceDir(), "session-counts.properties"));
            this.setHeader("DO NOT EDIT! - counts how many times simulations have been run");
        }

        public void setCount(String string, String string2, int n) {
            this.setProperty(SessionCountsFile.getCountKey(string, string2), n);
        }

        public int getCount(String string, String string2) {
            return this.getPropertyInt(SessionCountsFile.getCountKey(string, string2), 0);
        }

        public void setCountSince(String string, String string2, int n) {
            this.setProperty(SessionCountsFile.getSinceKey(string, string2), n);
        }

        public int getCountSince(String string, String string2) {
            return this.getPropertyInt(SessionCountsFile.getSinceKey(string, string2), 0);
        }

        public void setTotal(int n) {
            this.setProperty("total.count", n);
        }

        public int getTotal() {
            return this.getPropertyInt("total.count", 0);
        }
    }
}

