/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.view.piccolo.lifelike;

import edu.colorado.phet.circuitconstructionkit.CCKModule;
import edu.colorado.phet.circuitconstructionkit.model.CCKModel;
import edu.colorado.phet.circuitconstructionkit.model.analysis.CircuitSolutionListener;
import edu.colorado.phet.circuitconstructionkit.model.components.Bulb;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.ComponentNode;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.lifelike.BulbNode;
import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.view.ModelSlider;
import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import java.awt.BasicStroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BulbComponentNode
extends ComponentNode {
    private BulbNode bulbNode;
    private Bulb bulb;
    private CCKModule module;
    private CircuitSolutionListener circuitSolutionListener = new CircuitSolutionListener(){

        public void circuitSolverFinished() {
            BulbComponentNode.this.updateIntensity();
        }
    };
    ModelSlider dxSlider = new ModelSlider("dx", "", -10.0, 10.0, 0.0);
    ModelSlider dySlider = new ModelSlider("dy", "", -10.0, 10.0, 0.0);
    ModelSlider sxSlider = new ModelSlider("sx", "", 0.0, 3.0, 1.0);
    ModelSlider sySlider = new ModelSlider("sy", "", 0.0, 3.0, 1.0);
    ModelSlider dThetaSlider = new ModelSlider("dTheta", "", Math.PI * -2, Math.PI * 2, 0.0);

    public BulbComponentNode(CCKModel cCKModel, Bulb bulb, JComponent jComponent, CCKModule cCKModule) {
        super(cCKModel, bulb, jComponent, cCKModule);
        this.bulb = bulb;
        this.module = cCKModule;
        this.bulbNode = new BulbNode(bulb);
        this.addChild(this.bulbNode);
        cCKModel.getCircuitSolver().addSolutionListener(this.circuitSolutionListener);
        this.bulbNode.transformBy(AffineTransform.getScaleInstance(2.0, 2.5));
        this.update();
        this.runParamTest();
        this.getHighlightNode().setStroke(new BasicStroke(0.016666668f));
    }

    public void delete() {
        super.delete();
        this.getCCKModel().getCircuitSolver().removeSolutionListener(this.circuitSolutionListener);
        this.bulbNode.delete();
    }

    public BulbNode getBulbNode() {
        return this.bulbNode;
    }

    private double getTilt() {
        double d = Math.atan2(this.bulbNode.getCoverShape().getBounds().getWidth() / 2.0, this.bulbNode.getCoverShape().getBounds().getHeight());
        return this.bulb.isConnectAtLeft() ? d + 1.5707963267948966 : -d;
    }

    public static double getTiltValue(Bulb bulb) {
        double d = new BulbNode(bulb).getCoverShape().getBounds().getWidth();
        double d2 = new BulbNode(bulb).getCoverShape().getBounds().getHeight();
        return -Math.atan2(d, d2);
    }

    private void updateIntensity() {
        this.bulbNode.setIntensity(this.bulb.getIntensity());
    }

    private void runParamTest() {
        JFrame jFrame = new JFrame();
        VerticalLayoutPanel verticalLayoutPanel = new VerticalLayoutPanel();
        ChangeListener changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                BulbComponentNode.this.update();
            }
        };
        verticalLayoutPanel.add(this.dxSlider);
        verticalLayoutPanel.add(this.dySlider);
        verticalLayoutPanel.add(this.sxSlider);
        verticalLayoutPanel.add(this.sySlider);
        verticalLayoutPanel.add(this.dThetaSlider);
        this.dxSlider.addChangeListener(changeListener);
        this.dySlider.addChangeListener(changeListener);
        this.sxSlider.addChangeListener(changeListener);
        this.sySlider.addChangeListener(changeListener);
        this.dThetaSlider.addChangeListener(changeListener);
        jFrame.setContentPane(verticalLayoutPanel);
        jFrame.pack();
        jFrame.setDefaultCloseOperation(3);
    }

    private AffineTransform createTransform() {
        double d = 1.0;
        if (!this.bulb.isConnectAtLeft()) {
            d = -1.0;
        }
        double d2 = d * this.getTilt();
        Point2D point2D = this.bulb.getStartPoint();
        Point2D point2D2 = this.bulb.getEndPoint();
        AffineTransform affineTransform = new AffineTransform();
        double d3 = new ImmutableVector2D(point2D, point2D2).getAngle() + 0.3 + d2;
        affineTransform.rotate(d3, point2D.getX(), point2D.getY());
        affineTransform.translate(point2D.getX(), point2D.getY());
        affineTransform.scale(0.5549999999999999, 0.681375);
        affineTransform.translate(-1.0, -2.3);
        return affineTransform;
    }

    protected void update() {
        super.update();
        this.setTransform(this.createTransform());
        this.getHighlightNode().setVisible(false);
    }
}

