/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.model.mna;

import edu.colorado.phet.circuitconstructionkit.model.mna.LinearCircuitSolver;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinearCircuitSolution
implements LinearCircuitSolver.ISolution {
    HashMap<Integer, Double> nodeVoltages = new HashMap();
    HashMap<LinearCircuitSolver.Element, Double> branchCurrents = new HashMap();

    LinearCircuitSolution(HashMap<Integer, Double> hashMap, HashMap<LinearCircuitSolver.Element, Double> hashMap2) {
        this.nodeVoltages = hashMap;
        this.branchCurrents = hashMap2;
    }

    @Override
    public double getNodeVoltage(int n) {
        return this.nodeVoltages.get(n);
    }

    double getVoltage(LinearCircuitSolver.Element element) {
        return this.nodeVoltages.get(element.node1) - this.nodeVoltages.get(element.node0);
    }

    @Override
    public double getCurrent(LinearCircuitSolver.Element element) {
        if (this.branchCurrents.containsKey(element)) {
            return this.branchCurrents.get(element);
        }
        if (element instanceof LinearCircuitSolver.Resistor) {
            LinearCircuitSolver.Resistor resistor = (LinearCircuitSolver.Resistor)element;
            return -this.getVoltage(resistor) / resistor.resistance;
        }
        throw new RuntimeException("Solution does not contain current for element: " + element);
    }

    public String toString() {
        return "Solution{nodeVoltages=" + this.nodeVoltages + ", branchCurrents=" + this.branchCurrents + '}';
    }
}

