/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.model.grabbag;

import edu.colorado.phet.circuitconstructionkit.CCKModule;
import edu.colorado.phet.circuitconstructionkit.model.components.Resistor;
import edu.colorado.phet.circuitconstructionkit.model.grabbag.GrabBagResistor;
import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.Random;

public class GrabBagItem {
    private URL imageURL;
    private String name;
    private double resistance;
    private BufferedImage image;
    private double modelLength;
    private static final Random random = new Random();

    public GrabBagItem(String string, String string2, double d, double d2) {
        this.imageURL = GrabBagItem.class.getClassLoader().getResource("circuit-construction-kit/images/grabbag/" + string);
        this.modelLength = d2;
        if (this.imageURL == null) {
            throw new RuntimeException("Null image URL for name=" + string2 + ", imageURLString=" + string);
        }
        this.name = string2;
        this.resistance = d;
    }

    public String getName() {
        return this.name;
    }

    public double getResistance() {
        return this.resistance;
    }

    public BufferedImage getImage() {
        if (this.image == null) {
            try {
                this.image = ImageLoader.loadBufferedImage(this.imageURL);
            }
            catch (IOException iOException) {
                System.out.println("this = " + this);
                iOException.printStackTrace();
            }
        }
        return this.image;
    }

    public String toString() {
        return "name=" + this.name + ", imageURL=" + this.imageURL + ", resistance=" + this.resistance;
    }

    public Resistor createBranch(CCKModule cCKModule) {
        Rectangle2D rectangle2D = cCKModule.getModelBounds();
        double d = random.nextDouble() * rectangle2D.getWidth() * 0.9 + rectangle2D.getX();
        double d2 = random.nextDouble() * rectangle2D.getHeight() + rectangle2D.getY();
        Point2D.Double double_ = new Point2D.Double(d, d2);
        Vector2D vector2D = new Vector2D(1.0, 0.0);
        double d3 = this.modelLength / (double)this.image.getWidth() * (double)this.image.getHeight();
        GrabBagResistor grabBagResistor = new GrabBagResistor(double_, vector2D, this.modelLength, d3, cCKModule.getCircuitChangeListener(), this);
        grabBagResistor.setResistance(this.getResistance());
        return grabBagResistor;
    }
}

