/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.model;

import edu.colorado.phet.circuitconstructionkit.model.BranchSet;
import edu.colorado.phet.circuitconstructionkit.model.CircuitChangeListener;
import edu.colorado.phet.circuitconstructionkit.model.CircuitListener;
import edu.colorado.phet.circuitconstructionkit.model.CompositeCircuitChangeListener;
import edu.colorado.phet.circuitconstructionkit.model.Connection;
import edu.colorado.phet.circuitconstructionkit.model.DynamicBranch;
import edu.colorado.phet.circuitconstructionkit.model.Junction;
import edu.colorado.phet.circuitconstructionkit.model.analysis.KirkhoffSolver;
import edu.colorado.phet.circuitconstructionkit.model.analysis.Path;
import edu.colorado.phet.circuitconstructionkit.model.components.Branch;
import edu.colorado.phet.circuitconstructionkit.model.components.CircuitComponent;
import edu.colorado.phet.circuitconstructionkit.model.components.Switch;
import edu.colorado.phet.circuitconstructionkit.model.components.Wire;
import edu.colorado.phet.circuitconstructionkit.model.mna.MNAAdapter;
import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Circuit {
    private ArrayList<Branch> branches = new ArrayList();
    private ArrayList<Junction> junctions = new ArrayList();
    private ArrayList<CircuitListener> listeners = new ArrayList();
    private CircuitChangeListener circuitChangeListener;
    private MNAAdapter.CircuitResult solution;
    EditingObserver editingObserver = new EditingObserver();

    public Circuit() {
        this(new CompositeCircuitChangeListener());
    }

    public Circuit(CircuitChangeListener circuitChangeListener) {
        this.circuitChangeListener = circuitChangeListener;
    }

    public void addCircuitListener(CircuitListener circuitListener) {
        this.listeners.add(circuitListener);
    }

    public String toString() {
        return "Junctions=" + this.junctions + ", Branches=" + this.branches;
    }

    public void addJunction(Junction junction) {
        if (!this.junctions.contains(junction)) {
            this.junctions.add(junction);
            this.fireJunctionAdded(junction);
        }
    }

    private void fireJunctionAdded(Junction junction) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).junctionAdded(junction);
        }
    }

    public void removeJunction(Junction junction) {
        this.junctions.remove(junction);
        junction.delete();
        this.fireJunctionRemoved(junction);
    }

    public Branch[] getAdjacentBranches(Junction junction) {
        ArrayList<Branch> arrayList = new ArrayList<Branch>();
        for (Branch branch : this.branches) {
            if (!branch.hasJunction(junction)) continue;
            arrayList.add(branch);
        }
        return arrayList.toArray(new Branch[arrayList.size()]);
    }

    public void updateNeighbors(Junction junction) {
        for (Branch branch : this.branches) {
            if (!branch.hasJunction(junction)) continue;
            branch.notifyObservers();
        }
    }

    public int numJunctions() {
        return this.junctions.size();
    }

    public Junction junctionAt(int n) {
        return this.junctions.get(n);
    }

    public boolean hasBranch(Junction junction, Junction junction2) {
        for (Branch branch : this.branches) {
            if (!branch.hasJunction(junction) || !branch.hasJunction(junction2)) continue;
            return true;
        }
        return false;
    }

    public Junction[] getNeighbors(Junction junction) {
        ArrayList<Junction> arrayList = new ArrayList<Junction>();
        for (Branch branch : this.branches) {
            if (!branch.hasJunction(junction)) continue;
            arrayList.add(branch.opposite(junction));
        }
        return arrayList.toArray(new Junction[arrayList.size()]);
    }

    public void replaceJunction(Junction junction, Junction junction2) {
        for (Branch branch : this.branches) {
            if (branch.getStartJunction() == junction) {
                branch.setStartJunction(junction2);
            }
            if (branch.getEndJunction() != junction) continue;
            branch.setEndJunction(junction2);
        }
    }

    private void fireJunctionRemoved(Junction junction) {
        for (CircuitListener circuitListener : this.listeners) {
            circuitListener.junctionRemoved(junction);
        }
    }

    public void addBranch(Branch branch) {
        if (branch == null) {
            throw new RuntimeException("Null component.");
        }
        this.branches.add(branch);
        this.fireBranchAdded(branch);
        this.addJunction(branch.getStartJunction());
        this.addJunction(branch.getEndJunction());
        branch.addObserver(this.editingObserver);
        this.circuitChangeListener.circuitChanged();
    }

    public Branch[] getNeighbors(Branch branch) {
        Branch[] branchArray = this.getAdjacentBranches(branch.getStartJunction());
        Branch[] branchArray2 = this.getAdjacentBranches(branch.getEndJunction());
        ArrayList<Branch> arrayList = new ArrayList<Branch>();
        for (Branch branch2 : branchArray) {
            if (branch2 == branch) continue;
            arrayList.add(branch2);
        }
        for (Branch branch2 : branchArray2) {
            if (branch2 == branch) continue;
            arrayList.add(branch2);
        }
        return arrayList.toArray(new Branch[arrayList.size()]);
    }

    public void setSolution(MNAAdapter.CircuitResult circuitResult) {
        this.solution = circuitResult;
    }

    public boolean hasProblematicConfiguration() {
        Path[] pathArray;
        KirkhoffSolver.MatrixTable matrixTable = new KirkhoffSolver.MatrixTable(this);
        for (Path path : pathArray = matrixTable.getLoops()) {
            if (!this.isProblematicLoop(path)) continue;
            return true;
        }
        return false;
    }

    private boolean isProblematicLoop(Path path) {
        return path.containsCapacitor() && path.sumResistance() < 1.0;
    }

    private void notifyEditingChanged() {
        for (CircuitListener circuitListener : this.listeners) {
            circuitListener.editingChanged();
        }
    }

    public Junction[] split(Junction junction) {
        Branch[] branchArray = this.getAdjacentBranches(junction);
        Junction[] junctionArray = new Junction[branchArray.length];
        for (int i = 0; i < branchArray.length; ++i) {
            Point2D.Double double_;
            Branch branch = branchArray[i];
            Junction junction2 = branch.opposite(junction);
            ImmutableVector2D immutableVector2D = new Vector2D(junction2.getPosition(), junction.getPosition());
            double d = immutableVector2D.getMagnitude();
            double d2 = Math.abs(d - 0.243);
            immutableVector2D = immutableVector2D.getInstanceOfMagnitude(d2);
            Point2D.Double double_2 = double_ = immutableVector2D.getDestination(junction2.getPosition());
            if (branch instanceof CircuitComponent) {
                double_2 = junction.getPosition();
            }
            Junction junction3 = new Junction(((Point2D)double_2).getX(), ((Point2D)double_2).getY());
            branch.replaceJunction(junction, junction3);
            this.addJunction(junction3);
            junctionArray[i] = junction3;
            if (branch instanceof CircuitComponent) {
                ImmutableVector2D immutableVector2D2 = new ImmutableVector2D(junction.getPosition(), double_);
                Branch[] branchArray2 = this.getStrongConnections(junction3);
                BranchSet branchSet = new BranchSet(this, branchArray2);
                branchSet.translate(immutableVector2D2);
                continue;
            }
            this.updateNeighbors(junction3);
        }
        this.removeJunction(junction);
        this.fireJunctionsMoved();
        this.circuitChangeListener.circuitChanged();
        this.fireJunctionsSplit(junction, junctionArray);
        return junctionArray;
    }

    private void fireJunctionsSplit(Junction junction, Junction[] junctionArray) {
        for (CircuitListener circuitListener : this.listeners) {
            circuitListener.junctionsSplit(junction, junctionArray);
        }
    }

    public Branch[] getStrongConnections(Junction junction) {
        ArrayList<Branch> arrayList = new ArrayList<Branch>();
        this.getStrongConnections(arrayList, junction);
        return arrayList.toArray(new Branch[arrayList.size()]);
    }

    public Branch[] getStrongConnections(Branch branch, Junction junction) {
        ArrayList<Branch> arrayList = new ArrayList<Branch>();
        if (branch != null) {
            arrayList.add(branch);
        }
        this.getStrongConnections(arrayList, junction);
        if (branch != null) {
            arrayList.remove(branch);
        }
        return arrayList.toArray(new Branch[arrayList.size()]);
    }

    private void getStrongConnections(ArrayList<Branch> arrayList, Junction junction) {
        Branch[] branchArray;
        for (Branch branch : branchArray = this.getAdjacentBranches(junction)) {
            Junction junction2 = branch.opposite(junction);
            if (arrayList.contains(branch) || !(branch instanceof CircuitComponent)) continue;
            arrayList.add(branch);
            this.getStrongConnections(arrayList, junction2);
        }
    }

    public Branch[] getConnectedSubgraph(Junction junction) {
        ArrayList<Branch> arrayList = new ArrayList<Branch>();
        this.getConnectedSubgraph(arrayList, junction);
        return arrayList.toArray(new Branch[arrayList.size()]);
    }

    private void getConnectedSubgraph(ArrayList<Branch> arrayList, Junction junction) {
        Branch[] branchArray;
        for (Branch branch : branchArray = this.getAdjacentBranches(junction)) {
            if (branch instanceof Switch && !((Switch)branch).isClosed()) continue;
            Junction junction2 = branch.opposite(junction);
            if (arrayList.contains(branch)) continue;
            arrayList.add(branch);
            this.getConnectedSubgraph(arrayList, junction2);
        }
    }

    public void fireJunctionsMoved() {
        for (CircuitListener circuitListener : this.listeners) {
            circuitListener.junctionsMoved();
        }
    }

    public int numBranches() {
        return this.branches.size();
    }

    public int indexOf(Junction junction) {
        return this.junctions.indexOf(junction);
    }

    public Branch branchAt(int n) {
        return this.branches.get(n);
    }

    public void removeBranch(Branch branch) {
        branch.removeObserver(this.editingObserver);
        this.branches.remove(branch);
        branch.delete();
        this.fireBranchRemoved(branch);
        this.fireKirkhoffChanged();
        this.removeIfOrphaned(branch.getStartJunction());
        this.removeIfOrphaned(branch.getEndJunction());
    }

    private void removeIfOrphaned(Junction junction) {
        if (this.getAdjacentBranches(junction).length == 0) {
            this.removeJunction(junction);
        }
    }

    private void fireBranchAdded(Branch branch) {
        for (CircuitListener circuitListener : this.listeners) {
            circuitListener.branchAdded(branch);
        }
    }

    private void fireBranchRemoved(Branch branch) {
        for (CircuitListener circuitListener : this.listeners) {
            circuitListener.branchRemoved(branch);
        }
    }

    public void fireKirkhoffChanged() {
        this.circuitChangeListener.circuitChanged();
    }

    public Branch[] getBranches() {
        return this.branches.toArray(new Branch[this.branches.size()]);
    }

    public Junction[] getJunctions() {
        return this.junctions.toArray(new Junction[this.junctions.size()]);
    }

    public static Junction[] getJunctions(Branch[] branchArray) {
        ArrayList<Junction> arrayList = new ArrayList<Junction>();
        for (Branch branch : branchArray) {
            if (!arrayList.contains(branch.getStartJunction())) {
                arrayList.add(branch.getStartJunction());
            }
            if (arrayList.contains(branch.getEndJunction())) continue;
            arrayList.add(branch.getEndJunction());
        }
        return arrayList.toArray(new Junction[arrayList.size()]);
    }

    public void fireBranchesMoved(Branch[] branchArray) {
        for (CircuitListener circuitListener : this.listeners) {
            circuitListener.branchesMoved(branchArray);
        }
    }

    public double getVoltage(Shape shape, Shape shape2) {
        Area area = new Area(shape);
        area.intersect(new Area(shape2));
        if (!area.isEmpty()) {
            return 0.0;
        }
        Connection connection = this.getConnection(shape);
        Connection connection2 = this.getConnection(shape2);
        if (connection == null || connection2 == null) {
            return Double.NaN;
        }
        return this.getVoltage(connection, connection2);
    }

    public double getVoltage(Connection connection, Connection connection2) {
        if (connection.equals(connection2) || !this.getSameComponent(connection.getJunction(), connection2.getJunction())) {
            return 0.0;
        }
        double d = connection.getVoltageAddon();
        double d2 = -connection2.getVoltageAddon();
        double d3 = this.solution.getAverageNodeVoltage(this.indexOf(connection2.getJunction())) - this.solution.getAverageNodeVoltage(this.indexOf(connection.getJunction()));
        return d3 + d + d2;
    }

    private boolean getSameComponent(Junction junction, Junction junction2) {
        Branch[] branchArray;
        for (Branch branch : branchArray = this.getConnectedSubgraph(junction)) {
            if (!branch.hasJunction(junction2)) continue;
            return true;
        }
        return false;
    }

    public void setSelection(Branch branch) {
        this.clearSelection();
        branch.setSelected(true);
        this.notifySelectionChanged();
    }

    public void setSelection(Junction junction) {
        this.clearSelection();
        junction.setSelected(true);
        this.notifySelectionChanged();
    }

    private void notifySelectionChanged() {
        for (CircuitListener circuitListener : this.listeners) {
            circuitListener.selectionChanged();
        }
    }

    public void clearSelection() {
        for (Branch simpleObservableDebug : this.branches) {
            simpleObservableDebug.setSelected(false);
        }
        for (Junction junction : this.junctions) {
            junction.setSelected(false);
        }
        this.notifySelectionChanged();
    }

    public Branch[] getSelectedBranches() {
        ArrayList<Branch> arrayList = new ArrayList<Branch>();
        for (Branch branch : this.branches) {
            if (!branch.isSelected()) continue;
            arrayList.add(branch);
        }
        return arrayList.toArray(new Branch[arrayList.size()]);
    }

    public Junction[] getSelectedJunctions() {
        ArrayList<Junction> arrayList = new ArrayList<Junction>();
        for (Junction junction : this.junctions) {
            if (!junction.isSelected()) continue;
            arrayList.add(junction);
        }
        return arrayList.toArray(new Junction[arrayList.size()]);
    }

    public void selectAll() {
        for (Branch simpleObservableDebug : this.branches) {
            simpleObservableDebug.setSelected(true);
        }
        for (Junction junction : this.junctions) {
            junction.setSelected(true);
        }
    }

    public void fireJunctionsCollapsed(Junction junction, Junction junction2, Junction junction3) {
        for (CircuitListener circuitListener : this.listeners) {
            circuitListener.junctionsConnected(junction, junction2, junction3);
        }
    }

    public boolean isDynamic() {
        for (int i = 0; i < this.numBranches(); ++i) {
            if (!(this.branchAt(i) instanceof DynamicBranch)) continue;
            return true;
        }
        return false;
    }

    public void stepInTime(double d) {
        for (int i = 0; i < this.numBranches(); ++i) {
            if (!(this.branchAt(i) instanceof DynamicBranch)) continue;
            DynamicBranch dynamicBranch = (DynamicBranch)((Object)this.branchAt(i));
            dynamicBranch.stepInTime(d);
        }
    }

    public void resetDynamics() {
        for (int i = 0; i < this.numBranches(); ++i) {
            if (!(this.branchAt(i) instanceof DynamicBranch)) continue;
            DynamicBranch dynamicBranch = (DynamicBranch)((Object)this.branchAt(i));
            dynamicBranch.resetDynamics();
        }
    }

    public void setState(Circuit circuit) {
        int n;
        this.clear();
        for (n = 0; n < circuit.numJunctions(); ++n) {
            this.addJunction(circuit.junctionAt(n));
        }
        for (n = 0; n < circuit.numBranches(); ++n) {
            this.addBranch(circuit.branchAt(n));
        }
    }

    public void clear() {
        while (this.numBranches() > 0) {
            Branch branch = this.branchAt(0);
            this.removeBranch(branch);
        }
        while (this.numJunctions() > 0) {
            this.removeJunction(this.junctionAt(0));
        }
    }

    public boolean wouldConnectionCauseOverlappingBranches(Junction junction, Junction junction2) {
        Junction[] junctionArray = this.getNeighbors(junction);
        Junction[] junctionArray2 = this.getNeighbors(junction2);
        for (Junction junction3 : junctionArray) {
            for (Junction junction4 : junctionArray2) {
                if (junction3 != junction4) continue;
                return true;
            }
        }
        return false;
    }

    public void collapseJunctions(Junction junction, Junction junction2) {
        if (!junction.getPosition().equals(junction2.getPosition())) {
            throw new RuntimeException("Juncitons Not at same coordinates.");
        }
        this.removeJunction(junction);
        this.removeJunction(junction2);
        Junction junction3 = new Junction(junction.getX(), junction.getY());
        this.addJunction(junction3);
        this.replaceJunction(junction, junction3);
        this.replaceJunction(junction2, junction3);
        this.fireKirkhoffChanged();
        this.fireJunctionsCollapsed(junction, junction2, junction3);
    }

    public DragMatch getBestDragMatch(Branch[] branchArray, Vector2D vector2D) {
        return this.getBestDragMatch(Circuit.getJunctions(branchArray), vector2D);
    }

    public void removedUnusedJunctions(Junction junction) {
        Branch[] branchArray = this.getAdjacentBranches(junction);
        if (branchArray.length == 0) {
            this.removeJunction(junction);
        }
    }

    public void deleteSelectedBranches() {
        for (int i = 0; i < this.branches.size(); ++i) {
            Branch branch = this.branches.get(i);
            if (!branch.isSelected()) continue;
            this.removeBranch(branch);
            --i;
        }
    }

    public void desolderSelectedJunctions() {
        ArrayList<Junction> arrayList = new ArrayList<Junction>();
        for (int i = 0; i < this.junctions.size(); ++i) {
            Junction junction = this.junctions.get(i);
            if (arrayList.contains(junction) || !junction.isSelected() || this.getNeighbors(junction).length <= 1) continue;
            this.split(junction);
            arrayList.add(junction);
            i = -1;
        }
    }

    public void setAllComponentsEditing(boolean bl) {
        for (Branch branch : this.branches) {
            branch.setEditing(bl);
        }
    }

    public DragMatch getBestDragMatch(Junction[] junctionArray, Vector2D vector2D) {
        Junction[] junctionArray2 = this.getJunctions();
        ArrayList<Junction> arrayList = new ArrayList<Junction>();
        arrayList.addAll(Arrays.asList(junctionArray2));
        arrayList.removeAll(Arrays.asList(junctionArray));
        Junction[] junctionArray3 = arrayList.toArray(new Junction[arrayList.size()]);
        DragMatch dragMatch = null;
        for (Junction junction : junctionArray) {
            Point2D.Double double_ = vector2D.getDestination(junction.getPosition());
            Junction junction2 = this.getBestDragMatch(junction, double_, junctionArray3);
            if (junction2 == null) continue;
            DragMatch dragMatch2 = new DragMatch(junction, junction2);
            if (dragMatch != null && !(dragMatch2.getDistance() < dragMatch.getDistance())) continue;
            dragMatch = dragMatch2;
        }
        return dragMatch;
    }

    public Junction getBestDragMatch(Junction junction, Point2D point2D, Junction[] junctionArray) {
        Branch[] branchArray = this.getStrongConnections(junction);
        Junction junction2 = null;
        double d = Double.POSITIVE_INFINITY;
        for (Junction junction3 : junctionArray) {
            double d2 = point2D.distance(junction3.getPosition());
            if (junction3 == junction || this.hasBranch(junction, junction3) || this.wouldConnectionCauseOverlappingBranches(junction, junction3) || junction2 != null && !(d2 < d)) continue;
            boolean bl = !this.contains(branchArray, junction3);
            double d3 = 1.0;
            if (!(d2 <= d3) || !bl) continue;
            d = d2;
            junction2 = junction3;
        }
        return junction2;
    }

    private boolean contains(Branch[] branchArray, Junction junction) {
        for (Branch branch : branchArray) {
            if (!branch.hasJunction(junction)) continue;
            return true;
        }
        return false;
    }

    public Branch getBranch(Point2D point2D) {
        return this.detectBranch(new Rectangle2D.Double(point2D.getX(), point2D.getY(), 0.001, 0.001));
    }

    public Connection getConnection(Shape shape) {
        Branch branch = this.detectBranch(shape);
        Junction junction = this.detectJunction(shape);
        Connection connection = null;
        if (junction != null) {
            connection = new Connection.JunctionConnection(junction);
        } else if (branch != null) {
            Point2D.Double double_ = new Point2D.Double(shape.getBounds2D().getCenterX(), shape.getBounds2D().getCenterY());
            Point2D.Double double_2 = branch.getStartJunction().getPosition();
            Vector2D vector2D = new Vector2D(double_2, double_);
            double d = vector2D.getMagnitude();
            connection = new Connection.BranchConnection(branch, d);
        }
        return connection;
    }

    private Branch detectBranch(Shape shape) {
        Wire[] wireArray = this.getWires();
        Wire wire = null;
        for (Wire wire2 : wireArray) {
            Shape shape2 = wire2.getShape();
            Area area = new Area(shape);
            area.intersect(new Area(shape2));
            if (area.isEmpty()) continue;
            wire = wire2;
        }
        return wire;
    }

    private Wire[] getWires() {
        ArrayList<Wire> arrayList = new ArrayList<Wire>();
        for (Branch branch : this.branches) {
            if (!(branch instanceof Wire)) continue;
            arrayList.add((Wire)branch);
        }
        return arrayList.toArray(new Wire[arrayList.size()]);
    }

    private Junction detectJunction(Shape shape) {
        Junction[] junctionArray = this.getJunctions();
        Junction junction = null;
        for (Junction junction2 : junctionArray) {
            Area area = new Area(junction2.getShape());
            area.intersect(new Area(shape));
            if (area.isEmpty()) continue;
            junction = junction2;
        }
        return junction;
    }

    public void bumpAway(Junction junction) {
        for (int i = 0; i < 2; ++i) {
            this.bumpOnce(junction);
        }
    }

    public void bumpOnce(Junction junction) {
        Branch[] branchArray = this.getBranches();
        Branch[] branchArray2 = this.getStrongConnections(junction);
        for (Branch branch : branchArray) {
            if (branch.hasJunction(junction) || !branch.getShape().intersects(junction.getShape().getBounds2D())) continue;
            ImmutableVector2D immutableVector2D = branch.getDirectionVector();
            immutableVector2D = immutableVector2D.getNormalVector();
            immutableVector2D = immutableVector2D.getNormalizedInstance().getScaledInstance(junction.getShape().getBounds2D().getWidth());
            BranchSet branchSet = new BranchSet(this, branchArray2);
            branchSet.addJunction(junction);
            branchSet.translate(immutableVector2D);
            break;
        }
    }

    public static class DragMatch {
        private Junction source;
        private Junction target;

        public DragMatch(Junction junction, Junction junction2) {
            this.source = junction;
            this.target = junction2;
        }

        public Junction getSource() {
            return this.source;
        }

        public Junction getTarget() {
            return this.target;
        }

        public double getDistance() {
            return this.source.getDistance(this.target);
        }

        public String toString() {
            return "match, source=" + this.source + ", dest=" + this.target + ", dist=" + this.getDistance();
        }

        public Vector2D getVector() {
            return new Vector2D(this.source.getPosition(), this.target.getPosition());
        }
    }

    class EditingObserver
    implements SimpleObserver {
        EditingObserver() {
        }

        public void update() {
            Circuit.this.notifyEditingChanged();
        }
    }
}

