/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.lasers.view;

import edu.colorado.phet.lasers.model.LaserModel;
import edu.colorado.phet.lasers.view.WaveGraphic;
import java.awt.Color;
import java.awt.Component;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

public class StandingWaveGraphic
extends WaveGraphic {
    public StandingWaveGraphic(Component component, Point2D point2D, double d, double d2, double d3, double d4, Color color, LaserModel laserModel) {
        super(component, point2D, d, d2, d3, d4, color, laserModel.getResonatingCavity());
        laserModel.addModelElement(this);
    }

    public void stepInTime(double d) {
        super.stepInTime(d);
        GeneralPath generalPath = this.getWavePath();
        generalPath.reset();
        double d2 = Math.sin(this.getElapsedTime() / this.getPeriod() * Math.PI);
        Point2D point2D = this.getOrigin();
        generalPath.moveTo((float)point2D.getX(), (float)point2D.getY());
        for (int i = 0; i < this.getNumPts(); i += 3) {
            double d3 = this.getDx() * (double)i;
            double d4 = this.getAmplitude() * (d2 * Math.sin(d3 / this.getLambda() * Math.PI));
            generalPath.lineTo((float)(d3 + point2D.getX()), (float)(d4 + point2D.getY()));
        }
        this.update();
    }
}

