/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.lasers.model.atom;

import edu.colorado.phet.common.phetcommon.util.PhysicsUtil;
import edu.colorado.phet.common.quantum.model.Atom;
import edu.colorado.phet.common.quantum.model.AtomicState;
import edu.colorado.phet.common.quantum.model.EnergyEmissionStrategy;
import edu.colorado.phet.common.quantum.model.Photon;
import edu.colorado.phet.lasers.LasersConfig;
import edu.colorado.phet.lasers.model.atom.LaserElementProperties;

public class ThreeLevelElementProperties
extends LaserElementProperties {
    public static final double DEFAULT_STATE_LIFETIME = LasersConfig.DT / (double)LasersConfig.FPS * 100.0;
    private static double groundStateEnergy = -13.6;
    private static double[] energyLevels = new double[]{groundStateEnergy, groundStateEnergy + PhysicsUtil.wavelengthToEnergy(Photon.RED), groundStateEnergy + PhysicsUtil.wavelengthToEnergy(Photon.BLUE)};

    public ThreeLevelElementProperties() {
        super("Laser Atom", energyLevels, new EmissionStrategy(), DEFAULT_STATE_LIFETIME);
    }

    public AtomicState getHighEnergyState() {
        return this.getStates()[2];
    }

    private static class EmissionStrategy
    implements EnergyEmissionStrategy {
        private EmissionStrategy() {
        }

        public AtomicState emitEnergy(Atom atom) {
            return atom.getCurrState().getNextLowerEnergyState();
        }
    }
}

