/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.charts;

import edu.colorado.phet.common.charts.AbstractGrid;
import edu.colorado.phet.common.charts.Chart;
import edu.colorado.phet.common.charts.Orientation;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import java.awt.Color;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.geom.Line2D;

public class Grid
extends AbstractGrid {
    public Grid(Chart chart, Orientation orientation, Stroke stroke, Color color, double d, double d2) {
        super(chart, orientation, stroke, color, d, d2);
        chart.addListener(new Chart.Listener(){

            public void transformChanged(Chart chart) {
                Grid.this.update();
            }
        });
        this.update();
    }

    protected void update() {
        block3: {
            double[] dArray;
            Chart chart;
            Orientation orientation;
            block2: {
                this.clear();
                orientation = super.getOrientation();
                chart = super.getChart();
                dArray = this.getVisibleGridlines();
                if (!orientation.isVertical()) break block2;
                for (int i = 0; i < dArray.length; ++i) {
                    double d = dArray[i];
                    if (!chart.getRange().containsX(d)) continue;
                    Point point = chart.transform(d, chart.getRange().getMinY());
                    Point point2 = chart.transform(d, chart.getRange().getMaxY());
                    Line2D.Double double_ = new Line2D.Double(point.x, point.y, point2.x, point2.y);
                    PhetShapeGraphic phetShapeGraphic = new PhetShapeGraphic(chart.getComponent(), double_, this.getStroke(), this.getColor());
                    this.addGraphic(phetShapeGraphic);
                }
                break block3;
            }
            if (!orientation.isHorizontal()) break block3;
            for (int i = 0; i < dArray.length; ++i) {
                double d = dArray[i];
                if (!chart.getRange().containsY(d)) continue;
                Point point = chart.transform(chart.getRange().getMinX(), d);
                Point point3 = chart.transform(chart.getRange().getMaxX(), d);
                Line2D.Double double_ = new Line2D.Double(point.x, point.y, point3.x, point3.y);
                PhetShapeGraphic phetShapeGraphic = new PhetShapeGraphic(chart.getComponent(), double_, this.getStroke(), this.getColor());
                this.addGraphic(phetShapeGraphic);
            }
        }
    }
}

