/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.photoelectric;

import edu.colorado.phet.common.phetcommon.application.ApplicationConstructor;
import edu.colorado.phet.common.phetcommon.application.Module;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationLauncher;
import edu.colorado.phet.common.phetcommon.view.util.FrameSetup;
import edu.colorado.phet.photoelectric.PhotoelectricResources;
import edu.colorado.phet.photoelectric.controller.BeamControl;
import edu.colorado.phet.photoelectric.module.PhotoelectricModule;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;

public class PhotoelectricApplication
extends PhetApplication {
    private static final FrameSetup FRAME_SETUP = new FrameSetup.CenteredWithSize(1024, 680);
    public static final double DT = 12.0;
    public static final int FPS = 25;
    private JMenu optionsMenu;

    public PhotoelectricApplication(PhetApplicationConfig phetApplicationConfig) {
        super(phetApplicationConfig);
        this.getPhetFrame().setResizable(false);
        this.optionsMenu = new JMenu(PhotoelectricResources.getString("Menu.Options"));
        final PhotoelectricModule photoelectricModule = new PhotoelectricModule(this.getPhetFrame(), this);
        this.setModules(new Module[]{photoelectricModule});
        final JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(PhotoelectricResources.getString("Menu.PhotonView"));
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                photoelectricModule.setPhotonViewEnabled(jCheckBoxMenuItem.isSelected());
            }
        });
        this.optionsMenu.add(jCheckBoxMenuItem);
        final JCheckBoxMenuItem jCheckBoxMenuItem2 = new JCheckBoxMenuItem(PhotoelectricResources.getString("Options.photonsPerSecond"));
        jCheckBoxMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (jCheckBoxMenuItem2.isSelected()) {
                    photoelectricModule.getBeamControl().setMode(BeamControl.RATE);
                } else {
                    photoelectricModule.getBeamControl().setMode(BeamControl.INTENSITY);
                }
            }
        });
        this.optionsMenu.add(jCheckBoxMenuItem2);
        this.getPhetFrame().addMenu(this.optionsMenu);
    }

    public JMenu getOptionsMenu() {
        return this.optionsMenu;
    }

    public static void main(String[] stringArray) {
        ApplicationConstructor applicationConstructor = new ApplicationConstructor(){

            public PhetApplication getApplication(PhetApplicationConfig phetApplicationConfig) {
                return new PhotoelectricApplication(phetApplicationConfig);
            }
        };
        PhetApplicationConfig phetApplicationConfig = new PhetApplicationConfig(stringArray, "photoelectric");
        phetApplicationConfig.setFrameSetup(FRAME_SETUP);
        new PhetApplicationLauncher().launchSim(phetApplicationConfig, applicationConstructor);
    }
}

