/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.dischargelamps.control;

import edu.colorado.phet.common.phetcommon.util.PhetUtilities;
import edu.colorado.phet.common.phetcommon.view.util.PhetOptionPane;
import edu.colorado.phet.dischargelamps.DischargeLampModule;
import edu.colorado.phet.dischargelamps.DischargeLampsResources;
import edu.colorado.phet.dischargelamps.control.CurrentSlider;
import edu.colorado.phet.dischargelamps.model.DischargeLampModel;
import edu.colorado.phet.dischargelamps.model.ElectronPulser;
import edu.colorado.phet.dischargelamps.quantum.model.ElectronSource;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ElectronProductionControl
extends JPanel {
    private JRadioButton continuousModeRB;
    private JRadioButton singleShotModeRB;
    public static final ProductionMode CONTINUOUS = new ProductionMode();
    public static final ProductionMode SINGLE_SHOT = new ProductionMode();
    private DischargeLampModel model;
    private double currentDisplayFactor = 0.001;
    private DischargeLampModule module;
    private double maxCurrent;
    private double continuousCurrent;
    private CurrentSlider heaterControlSlider;
    private JComponent heaterControl;
    private JComponent modeSelectorControl;
    private JComponent fireElectronButton;

    public ElectronProductionControl(DischargeLampModule dischargeLampModule, double d) {
        this.module = dischargeLampModule;
        this.maxCurrent = d;
        this.model = (DischargeLampModel)dischargeLampModule.getModel();
        this.fireElectronButton = this.createFireElectronBtn();
        this.heaterControl = this.createHeaterControl();
        this.modeSelectorControl = this.createModeSelectorControl();
        this.continuousCurrent = d * 0.2;
        this.layoutPanel();
    }

    public void setProductionMode(ProductionMode productionMode) {
        if (productionMode == CONTINUOUS) {
            this.continuousModeRB.setSelected(true);
            this.heaterControl.setVisible(true);
            this.fireElectronButton.setVisible(false);
            this.model.setElectronProductionMode(ElectronSource.CONTINUOUS_MODE);
            this.model.setCurrent(this.continuousCurrent, this.currentDisplayFactor);
        }
        if (productionMode == SINGLE_SHOT) {
            this.continuousCurrent = this.model.getCurrent() / this.currentDisplayFactor;
            this.singleShotModeRB.setSelected(true);
            this.heaterControl.setVisible(false);
            this.fireElectronButton.setVisible(true);
            this.model.setCurrent(0.0);
            this.model.setElectronProductionMode(ElectronSource.SINGLE_SHOT_MODE);
        }
        this.module.setProductionType(productionMode);
    }

    private JComponent createModeSelectorControl() {
        this.continuousModeRB = new JRadioButton(new AbstractAction(DischargeLampsResources.getString("Controls.Continuous")){

            public void actionPerformed(ActionEvent actionEvent) {
                ElectronProductionControl.this.setProductionMode(CONTINUOUS);
            }
        });
        this.singleShotModeRB = new JRadioButton(new AbstractAction(DischargeLampsResources.getString("Controls.Single")){

            public void actionPerformed(ActionEvent actionEvent) {
                ElectronProductionControl.this.setProductionMode(SINGLE_SHOT);
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.continuousModeRB);
        buttonGroup.add(this.singleShotModeRB);
        this.singleShotModeRB.setSelected(true);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0);
        jPanel.add((Component)this.singleShotModeRB, gridBagConstraints);
        jPanel.add((Component)this.continuousModeRB, gridBagConstraints);
        this.singleShotModeRB.setSelected(true);
        this.setProductionMode(SINGLE_SHOT);
        return jPanel;
    }

    private JComponent createFireElectronBtn() {
        JButton jButton = new JButton(DischargeLampsResources.getString("Controls.FireElectron"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ElectronProductionControl.this.model.addModelElement(new ElectronPulser(ElectronProductionControl.this.model, ElectronProductionControl.this.maxCurrent / 2.0 * ElectronProductionControl.this.currentDisplayFactor));
            }
        });
        return jButton;
    }

    private JComponent createHeaterControl() {
        this.heaterControlSlider = new CurrentSlider(this.maxCurrent);
        this.heaterControlSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ElectronProductionControl.this.model.setCurrent(ElectronProductionControl.this.heaterControlSlider.getValue(), ElectronProductionControl.this.currentDisplayFactor);
            }
        });
        final JTextField jTextField = new JTextField();
        jTextField.setHorizontalAlignment(4);
        jTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = jTextField.getText();
                if (string.indexOf(37) >= 0) {
                    string = string.substring(0, string.indexOf(37));
                }
                try {
                    double d = Double.parseDouble(string);
                    if (d < 0.0 || d > 100.0) {
                        throw new NumberFormatException();
                    }
                    ElectronProductionControl.this.model.setCurrent(d * ElectronProductionControl.this.maxCurrent / 100.0, ElectronProductionControl.this.currentDisplayFactor);
                }
                catch (NumberFormatException numberFormatException) {
                    PhetOptionPane.showErrorDialog(PhetUtilities.getPhetFrame(), DischargeLampsResources.getString("Message.notPctFormat"));
                }
            }
        });
        final DecimalFormat decimalFormat = new DecimalFormat("##0%");
        this.heaterControlSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                double d = ElectronProductionControl.this.heaterControlSlider.getPctMax();
                jTextField.setText(decimalFormat.format(d));
            }
        });
        double d = this.heaterControlSlider.getPctMax();
        jTextField.setText(decimalFormat.format(d));
        this.model.addChangeListener(new DischargeLampModel.ChangeListenerAdapter(){

            public void currentChanged(DischargeLampModel.ChangeEvent changeEvent) {
                ElectronProductionControl.this.heaterControlSlider.setValue((int)(ElectronProductionControl.this.model.getCurrent() / ElectronProductionControl.this.currentDisplayFactor));
                double d = ElectronProductionControl.this.heaterControlSlider.getPctMax();
                jTextField.setText(decimalFormat.format(d));
            }
        });
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0);
        jPanel.add((Component)this.heaterControlSlider, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.anchor = 17;
        jPanel.add(Box.createHorizontalStrut(40), gridBagConstraints);
        jPanel.add((Component)jTextField, gridBagConstraints);
        return jPanel;
    }

    private void layoutPanel() {
        this.setBorder(new LineBorder(Color.black, 1));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(3, 0, 3, 0), 0, 0);
        JLabel jLabel = new JLabel(DischargeLampsResources.getString("Controls.ElectronProduction"));
        Font font = jLabel.getFont();
        Font font2 = new Font(font.getName(), 1, font.getSize());
        jLabel.setFont(font2);
        gridBagConstraints.gridwidth = 2;
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        this.add((Component)this.modeSelectorControl, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.add(Box.createHorizontalStrut(200), gridBagConstraints);
        this.add(Box.createVerticalStrut(30), gridBagConstraints);
        this.add((Component)this.fireElectronButton, gridBagConstraints);
        this.add((Component)this.heaterControl, gridBagConstraints);
    }

    public static class ProductionMode {
        private ProductionMode() {
        }
    }
}

