/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.lasers.model.atom;

import edu.colorado.phet.common.phetcommon.util.PhysicsUtil;
import edu.colorado.phet.common.quantum.model.Atom;
import edu.colorado.phet.common.quantum.model.AtomicState;
import edu.colorado.phet.common.quantum.model.EnergyEmissionStrategy;
import edu.colorado.phet.common.quantum.model.Photon;
import edu.colorado.phet.lasers.LasersConfig;
import edu.colorado.phet.lasers.model.atom.LaserElementProperties;

public class TwoLevelElementProperties
extends LaserElementProperties {
    public static final double DEFAULT_STATE_LIFETIME = LasersConfig.DT / (double)LasersConfig.FPS * 100.0;
    private static double groundStateEnergy = -13.6;
    private static double[] energyLevels = new double[]{groundStateEnergy, groundStateEnergy + PhysicsUtil.wavelengthToEnergy(Photon.RED)};
    private AtomicState dummyHighEnergyState = new AtomicState();

    public TwoLevelElementProperties() {
        super("Laser Atom", energyLevels, new EmissionStrategy(), DEFAULT_STATE_LIFETIME);
    }

    public AtomicState getHighEnergyState() {
        return this.dummyHighEnergyState;
    }

    private static class EmissionStrategy
    implements EnergyEmissionStrategy {
        private EmissionStrategy() {
        }

        public AtomicState emitEnergy(Atom atom) {
            return atom.getCurrState().getNextLowerEnergyState();
        }
    }
}

