/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.lasers.controller;

import edu.colorado.phet.common.phetcommon.util.PhysicsUtil;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import edu.colorado.phet.lasers.LasersResources;
import edu.colorado.phet.lasers.controller.module.BaseLaserModule;
import edu.colorado.phet.lasers.view.PhotonGraphic;
import edu.colorado.phet.lasers.view.util.ViewUtils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class WaveViewControlPanel
extends JPanel {
    private BaseLaserModule module;
    private ButtonGroup lasingPhotonBG;
    private JRadioButton lasingPhotonViewRB;
    private JRadioButton lasingWaveViewRB;

    public WaveViewControlPanel(BaseLaserModule baseLaserModule) {
        this.module = baseLaserModule;
        this.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        ViewUtils.setBorder(jPanel, LasersResources.getString("WaveViewControlPanel.lasingPanelTitle"));
        this.lasingPhotonBG = new ButtonGroup();
        this.lasingPhotonViewRB = new JRadioButton(LasersResources.getString("WaveViewControlPanel.photonView"));
        this.lasingWaveViewRB = new JRadioButton(LasersResources.getString("WaveViewControlPanel.waveView"));
        this.lasingPhotonBG.add(this.lasingPhotonViewRB);
        this.lasingPhotonBG.add(this.lasingWaveViewRB);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0);
        jPanel.add((Component)this.lasingPhotonViewRB, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.lasingWaveViewRB, gridBagConstraints);
        this.lasingPhotonViewRB.addActionListener(new LasingPhotonRBListener());
        this.lasingWaveViewRB.addActionListener(new LasingPhotonRBListener());
        gridBagConstraints.gridy = 0;
        ++gridBagConstraints.gridx;
        this.add((Component)jPanel, gridBagConstraints);
        baseLaserModule.setPumpingPhotonView(2);
        this.lasingPhotonViewRB.setSelected(true);
        baseLaserModule.setLasingPhotonView(0);
    }

    private class LasingPhotonRBListener
    implements ActionListener {
        private LasingPhotonRBListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JRadioButton jRadioButton = SwingUtils.getSelection(WaveViewControlPanel.this.lasingPhotonBG);
            double d = WaveViewControlPanel.this.module.getLaserModel().getMiddleEnergyState().getEnergyLevel() - WaveViewControlPanel.this.module.getLaserModel().getGroundState().getEnergyLevel();
            if (jRadioButton == WaveViewControlPanel.this.lasingPhotonViewRB) {
                PhotonGraphic.setAllVisible(true, PhysicsUtil.energyToWavelength(d));
                WaveViewControlPanel.this.module.setLasingPhotonView(0);
            }
            if (jRadioButton == WaveViewControlPanel.this.lasingWaveViewRB) {
                PhotonGraphic.setAllVisible(false, PhysicsUtil.energyToWavelength(d));
                WaveViewControlPanel.this.module.setLasingPhotonView(1);
            }
        }
    }
}

