/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.quantum.model;

import edu.colorado.phet.common.collision.SolidSphere;
import edu.colorado.phet.common.phetcommon.util.EventChannel;
import edu.colorado.phet.common.quantum.model.AtomicState;
import edu.colorado.phet.common.quantum.model.Photon;
import edu.colorado.phet.common.quantum.model.PhotonEmissionListener;
import edu.colorado.phet.common.quantum.model.PhotonEmittedEvent;
import edu.colorado.phet.common.quantum.model.QuantumModel;
import edu.colorado.phet.common.quantum.model.StateLifetimeManager;
import java.awt.geom.Point2D;
import java.util.EventListener;
import java.util.EventObject;

public class Atom
extends SolidSphere {
    private static int s_radius = 15;
    private static int s_mass = 1000;
    private AtomicState groundState;
    private AtomicState highestEnergyState;
    private StateLifetimeManager stateLifetimeManager;
    private QuantumModel model;
    private AtomicState currState;
    private AtomicState[] states;
    private boolean isStateLifetimeFixed = false;
    private EventChannel stateChangeChannel = new EventChannel(ChangeListener.class);
    private ChangeListener changeListenerProxy = (ChangeListener)this.stateChangeChannel.getListenerProxy();
    private EventChannel listenerChannel = new EventChannel(LeftSystemListener.class);
    private LeftSystemListener leftSystemListenerProxy = (LeftSystemListener)this.listenerChannel.getListenerProxy();
    private EventChannel photonEventChannel = new EventChannel(PhotonEmissionListener.class);
    PhotonEmissionListener photonEmittedListenerProxy = (PhotonEmissionListener)this.photonEventChannel.getListenerProxy();

    public Atom(QuantumModel quantumModel, int n) {
        this(quantumModel, n, false);
    }

    public Atom(QuantumModel quantumModel, int n, boolean bl) {
        super(s_radius);
        this.model = quantumModel;
        this.isStateLifetimeFixed = bl;
        this.setMass(s_mass);
        this.setCurrState(quantumModel.getGroundState());
        this.setNumEnergyLevels(n, quantumModel);
    }

    public AtomicState getCurrState() {
        return this.currState;
    }

    public AtomicState[] getStates() {
        return this.states;
    }

    protected QuantumModel getModel() {
        return this.model;
    }

    public void setStates(AtomicState[] atomicStateArray) {
        this.states = atomicStateArray;
        double d = -1.7976931348623157E308;
        for (int i = 0; i < atomicStateArray.length; ++i) {
            AtomicState atomicState = atomicStateArray[i];
            double d2 = atomicState.getEnergyLevel();
            if (!(d2 > d)) continue;
            d = d2;
            this.highestEnergyState = atomicState;
        }
        this.groundState = this.getLowestEnergyState();
        this.setCurrState(this.groundState);
    }

    public void setNumEnergyLevels(int n, QuantumModel quantumModel) {
        this.states = new AtomicState[n];
        this.states[0] = quantumModel.getGroundState();
        this.groundState = this.states[0];
        this.highestEnergyState = this.states[this.states.length - 1];
    }

    public AtomicState getLowestEnergyState() {
        AtomicState atomicState = null;
        double d = Double.MAX_VALUE;
        for (int i = 0; i < this.states.length; ++i) {
            AtomicState atomicState2 = this.states[i];
            if (!(atomicState2.getEnergyLevel() < d)) continue;
            d = atomicState2.getEnergyLevel();
            atomicState = atomicState2;
        }
        return atomicState;
    }

    public AtomicState getEnergyStateAfterEmission() {
        return this.currState.getNextLowerEnergyState();
    }

    public boolean isStateLifetimeFixed() {
        return this.isStateLifetimeFixed;
    }

    public void setPosition(double d, double d2) {
        super.setPosition(d, d2);
        if (this.changeListenerProxy != null) {
            this.changeListenerProxy.positionChanged(new ChangeEvent(this, null, null));
        }
    }

    public void setPosition(Point2D point2D) {
        super.setPosition(point2D);
        if (this.changeListenerProxy != null) {
            this.changeListenerProxy.positionChanged(new ChangeEvent(this, null, null));
        }
    }

    public void setCurrState(AtomicState atomicState) {
        AtomicState atomicState2 = this.currState;
        if (this.stateLifetimeManager != null) {
            this.stateLifetimeManager.kill();
        }
        this.currState = atomicState;
        if (atomicState2 != null) {
            atomicState2.leaveState(this);
        }
        if (atomicState != null) {
            atomicState.enterState(this);
        }
        this.stateLifetimeManager = new StateLifetimeManager(this, true, this.model);
        this.changeListenerProxy.stateChanged(new ChangeEvent(this, atomicState, atomicState2));
    }

    protected void emitPhoton(Photon photon) {
        this.photonEmittedListenerProxy.photonEmitted(new PhotonEmittedEvent(this, photon));
    }

    public void collideWithPhoton(Photon photon) {
        this.currState.collideWithPhoton(this, photon);
    }

    public int getCurrStateNumber() {
        for (int i = 0; i < this.states.length; ++i) {
            if (!this.getCurrState().equals(this.states[i])) continue;
            return i;
        }
        return 0;
    }

    public AtomicState getGroundState() {
        return this.groundState;
    }

    public AtomicState getHighestEnergyState() {
        return this.highestEnergyState;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.stateChangeChannel.addListener(changeListener);
    }

    public void addLeftSystemListener(LeftSystemListener leftSystemListener) {
        this.listenerChannel.addListener(leftSystemListener);
    }

    public void addPhotonEmittedListener(PhotonEmissionListener photonEmissionListener) {
        this.photonEventChannel.addListener(photonEmissionListener);
    }

    public class ChangeEvent
    extends EventObject {
        private AtomicState currState;
        private AtomicState prevState;

        public ChangeEvent(Atom atom2, AtomicState atomicState, AtomicState atomicState2) {
            super(atom2);
            this.prevState = atomicState2;
            this.currState = atomicState;
        }

        public AtomicState getCurrState() {
            return this.currState;
        }

        public AtomicState getPrevState() {
            return this.prevState;
        }
    }

    public static interface ChangeListener
    extends EventListener {
        public void stateChanged(ChangeEvent var1);

        public void positionChanged(ChangeEvent var1);
    }

    public static class ChangeListenerAdapter
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
        }

        public void positionChanged(ChangeEvent changeEvent) {
        }
    }

    public static interface LeftSystemListener
    extends EventListener {
    }
}

