/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.model.mna;

import edu.colorado.phet.circuitconstructionkit.model.mna.ResultSet;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimestepSubdivisions<A> {
    private double errorThreshold;
    private double minDT;

    public TimestepSubdivisions(double d, double d2) {
        this.errorThreshold = d;
        this.minDT = d2;
    }

    public ResultSet<A> stepInTimeWithHistory(A a, Steppable<A> steppable, double d) {
        double d2;
        A a2 = a;
        ArrayList arrayList = new ArrayList();
        for (double d3 = 0.0; d3 < d; d3 += d2) {
            int n;
            double d4 = arrayList.size() > 0 ? arrayList.get((int)(arrayList.size() - 1)).dt : d;
            d2 = this.getTimestep(a2, steppable, d4 * (double)(n = arrayList.size() > 0 ? 2 : 1));
            if (d2 + d3 > d) {
                d2 = d - d3;
            }
            a2 = steppable.update(a2, d2);
            arrayList.add(new ResultSet.State<A>(d2, a2));
        }
        return new ResultSet(arrayList);
    }

    protected double getTimestep(A a, Steppable<A> steppable, double d) {
        if (d < this.minDT) {
            System.out.println("Time step too small");
            return this.minDT;
        }
        if (this.errorAcceptable(a, steppable, d)) {
            return d;
        }
        return this.getTimestep(a, steppable, d / 2.0);
    }

    protected boolean errorAcceptable(A a, Steppable<A> steppable, double d) {
        A a2;
        A a3;
        A a4 = steppable.update(a, d);
        return steppable.distance(a4, a3 = steppable.update(a2 = steppable.update(a, d / 2.0), d / 2.0)) < this.errorThreshold;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Steppable<A> {
        public double distance(A var1, A var2);

        public A update(A var1, double var2);
    }
}

