/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.model.mna;

import edu.colorado.phet.circuitconstructionkit.model.mna.LinearCircuitSolver;
import edu.colorado.phet.circuitconstructionkit.model.mna.MNAAdapter;
import edu.colorado.phet.circuitconstructionkit.model.mna.TimestepSubdivisions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicCircuit {
    private List<LinearCircuitSolver.Battery> batteries;
    private List<LinearCircuitSolver.Resistor> resistors;
    private List<LinearCircuitSolver.CurrentSource> currents;
    private List<ResistiveBattery> resistiveBatteries;
    private List<DynamicCapacitor> capacitors;
    private List<DynamicInductor> inductors;
    private LinearCircuitSolver solver;

    public String toString() {
        return "DynamicCircuit{batteries=" + this.batteries + ", resistors=" + this.resistors + ", currents=" + this.currents + ", resistiveBatteries=" + this.resistiveBatteries + ", capacitors=" + this.capacitors + ", inductors=" + this.inductors + '}';
    }

    public DynamicCircuit(List<LinearCircuitSolver.Battery> list, List<LinearCircuitSolver.Resistor> list2, List<LinearCircuitSolver.CurrentSource> list3, List<ResistiveBattery> list4, List<DynamicCapacitor> list5, List<DynamicInductor> list6, LinearCircuitSolver linearCircuitSolver) {
        this.batteries = list;
        this.capacitors = list5;
        this.currents = list3;
        this.inductors = list6;
        this.resistiveBatteries = list4;
        this.resistors = list2;
        this.solver = linearCircuitSolver;
    }

    public static double euclideanDistance(ArrayList<Double> arrayList, ArrayList<Double> arrayList2) {
        return DynamicCircuit.euclideanDistance(DynamicCircuit.toArray(arrayList), DynamicCircuit.toArray(arrayList2));
    }

    private static double[] toArray(ArrayList<Double> arrayList) {
        double[] dArray = new double[arrayList.size()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = arrayList.get(i);
        }
        return dArray;
    }

    public static double euclideanDistance(double[] dArray, double[] dArray2) {
        if (dArray.length != dArray2.length) {
            throw new RuntimeException("Vector length mismatch");
        }
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += Math.pow(dArray[i] - dArray2[i], 2.0);
        }
        return Math.sqrt(d);
    }

    public DynamicCircuitSolution solvePropagate(double d) {
        Result result = this.toMNACircuit(d);
        return new DynamicCircuitSolution(this, this.solver.solve(result.mnaCircuit), result.currentCompanions);
    }

    public MNAAdapter.CircuitResult solveWithSudbivisions(TimestepSubdivisions<DynamicState> timestepSubdivisions, double d) {
        TimestepSubdivisions.Steppable<DynamicState> steppable = new TimestepSubdivisions.Steppable<DynamicState>(){

            @Override
            public DynamicState update(DynamicState dynamicState, double d) {
                return dynamicState.update(d);
            }

            @Override
            public double distance(DynamicState dynamicState, DynamicState dynamicState2) {
                int n;
                int n2;
                ArrayList<Double> arrayList = new ArrayList<Double>();
                for (n2 = 0; n2 < dynamicState.circuit.capacitors.size(); ++n2) {
                    arrayList.add(((DynamicCapacitor)dynamicState.circuit.capacitors.get(n2)).getCurrent());
                }
                for (n2 = 0; n2 < dynamicState.circuit.inductors.size(); ++n2) {
                    arrayList.add(((DynamicInductor)dynamicState.circuit.inductors.get(n2)).getCurrent());
                }
                ArrayList<Double> arrayList2 = new ArrayList<Double>();
                for (n = 0; n < dynamicState2.circuit.capacitors.size(); ++n) {
                    arrayList2.add(((DynamicCapacitor)dynamicState2.circuit.capacitors.get(n)).getCurrent());
                }
                for (n = 0; n < dynamicState2.circuit.inductors.size(); ++n) {
                    arrayList2.add(((DynamicInductor)dynamicState2.circuit.inductors.get(n)).getCurrent());
                }
                return DynamicCircuit.euclideanDistance(arrayList, arrayList2);
            }
        };
        return new MNAAdapter.CircuitResult(timestepSubdivisions.stepInTimeWithHistory(new DynamicState(this, null), steppable, d));
    }

    DynamicCircuit updateCircuit(DynamicCircuitSolution dynamicCircuitSolution) {
        ArrayList<DynamicCapacitor> arrayList = new ArrayList<DynamicCapacitor>();
        for (DynamicCapacitor object : this.capacitors) {
            arrayList.add(new DynamicCapacitor(object.capacitor, new DynamicElementState(dynamicCircuitSolution.getNodeVoltage(object.capacitor.node1) - dynamicCircuitSolution.getNodeVoltage(object.capacitor.node0), dynamicCircuitSolution.getCurrent(object.capacitor))));
        }
        ArrayList arrayList2 = new ArrayList();
        for (DynamicInductor dynamicInductor : this.inductors) {
            arrayList2.add(new DynamicInductor(dynamicInductor.inductor, new DynamicElementState(dynamicCircuitSolution.getNodeVoltage(((DynamicInductor)dynamicInductor).inductor.node1) - dynamicCircuitSolution.getNodeVoltage(((DynamicInductor)dynamicInductor).inductor.node0), dynamicCircuitSolution.getCurrent(dynamicInductor.inductor))));
        }
        return new DynamicCircuit(this.batteries, this.resistors, this.currents, this.resistiveBatteries, arrayList, arrayList2, this.solver);
    }

    Result toMNACircuit(double d) {
        LinearCircuitSolver.Resistor resistor;
        LinearCircuitSolver.Battery battery;
        double d2;
        double d3;
        Object object;
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        ArrayList<LinearCircuitSolver.Resistor> arrayList3 = new ArrayList<LinearCircuitSolver.Resistor>();
        ArrayList arrayList4 = new ArrayList();
        HashMap<LinearCircuitSolver.Element, SolutionToDouble> hashMap = new HashMap<LinearCircuitSolver.Element, SolutionToDouble>();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        ArrayList<LinearCircuitSolver.Element> arrayList5 = new ArrayList<LinearCircuitSolver.Element>();
        arrayList5.addAll(this.batteries);
        arrayList5.addAll(this.resistors);
        arrayList5.addAll(this.resistiveBatteries);
        arrayList5.addAll(this.currents);
        for (DynamicCapacitor arrayList6 : this.capacitors) {
            arrayList5.add(arrayList6.capacitor);
        }
        for (DynamicInductor dynamicInductor : this.inductors) {
            arrayList5.add(dynamicInductor.inductor);
        }
        for (LinearCircuitSolver.Element element : arrayList5) {
            hashSet.add(element.node0);
            hashSet.add(element.node1);
        }
        for (ResistiveBattery resistiveBattery : this.resistiveBatteries) {
            int n = (Integer)Collections.max(hashSet) + 1;
            hashSet.add(n);
            object = new LinearCircuitSolver.Battery(resistiveBattery.node0, n, resistiveBattery.voltage);
            LinearCircuitSolver.Resistor resistor2 = new LinearCircuitSolver.Resistor(n, resistiveBattery.node1, resistiveBattery.resistance);
            arrayList2.add(object);
            arrayList3.add(resistor2);
            hashMap.put(resistiveBattery, new SolutionToDouble((LinearCircuitSolver.Battery)object){
                final /* synthetic */ LinearCircuitSolver.Battery val$idealBattery;
                {
                    this.val$idealBattery = battery;
                }

                public double getValue(LinearCircuitSolver.ISolution iSolution) {
                    return iSolution.getCurrent(this.val$idealBattery);
                }
            });
        }
        for (DynamicCapacitor dynamicCapacitor : this.capacitors) {
            Capacitor capacitor = dynamicCapacitor.capacitor;
            object = dynamicCapacitor.state;
            int n = (Integer)Collections.max(hashSet) + 1;
            hashSet.add(n);
            d3 = d / 2.0 / capacitor.capacitance;
            d2 = ((DynamicElementState)object).voltage - d3 * ((DynamicElementState)object).current;
            battery = new LinearCircuitSolver.Battery(capacitor.node0, n, d2);
            resistor = new LinearCircuitSolver.Resistor(n, capacitor.node1, d3);
            arrayList2.add(battery);
            arrayList3.add(resistor);
            hashMap.put(capacitor, new SolutionToDouble(){

                public double getValue(LinearCircuitSolver.ISolution iSolution) {
                    return iSolution.getCurrent(battery);
                }
            });
        }
        for (DynamicInductor dynamicInductor : this.inductors) {
            Inductor inductor = dynamicInductor.getInductor();
            object = dynamicInductor.state;
            int n = (Integer)Collections.max(hashSet) + 1;
            hashSet.add(n);
            d3 = 2.0 * inductor.inductance / d;
            d2 = ((DynamicElementState)object).voltage + d3 * ((DynamicElementState)object).current;
            battery = new LinearCircuitSolver.Battery(n, inductor.node0, d2);
            resistor = new LinearCircuitSolver.Resistor(n, inductor.node1, d3);
            arrayList2.add(battery);
            arrayList3.add(resistor);
            hashMap.put(inductor, new SolutionToDouble(){

                public double getValue(LinearCircuitSolver.ISolution iSolution) {
                    return iSolution.getCurrent(battery);
                }
            });
        }
        ArrayList<LinearCircuitSolver.Battery> arrayList7 = new ArrayList<LinearCircuitSolver.Battery>(this.batteries);
        arrayList7.addAll(arrayList2);
        ArrayList<LinearCircuitSolver.Resistor> arrayList = new ArrayList<LinearCircuitSolver.Resistor>(this.resistors);
        arrayList.addAll(arrayList3);
        ArrayList<LinearCircuitSolver.CurrentSource> arrayList6 = new ArrayList<LinearCircuitSolver.CurrentSource>(this.currents);
        arrayList6.addAll(arrayList4);
        return new Result(new LinearCircuitSolver.Circuit((List<LinearCircuitSolver.Battery>)arrayList7, arrayList, arrayList6), hashMap);
    }

    public static class Capacitor
    extends LinearCircuitSolver.Element {
        double capacitance;

        public Capacitor(int n, int n2, double d) {
            super(n, n2);
            this.capacitance = d;
        }
    }

    public static class DynamicCapacitor {
        Capacitor capacitor;
        DynamicElementState state;

        public DynamicCapacitor(Capacitor capacitor, DynamicElementState dynamicElementState) {
            this.capacitor = capacitor;
            this.state = dynamicElementState;
        }

        public double getCurrent() {
            return this.state.current;
        }

        public String toString() {
            return "DynamicCapacitor{capacitor=" + this.capacitor + ", state=" + this.state + '}';
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DynamicCircuitSolution {
        DynamicCircuit circuit;
        LinearCircuitSolver.ISolution mnaSolution;
        HashMap<LinearCircuitSolver.Element, SolutionToDouble> currentCompanions;

        public DynamicCircuitSolution(DynamicCircuit dynamicCircuit2, LinearCircuitSolver.ISolution iSolution, HashMap<LinearCircuitSolver.Element, SolutionToDouble> hashMap) {
            this.circuit = dynamicCircuit2;
            this.mnaSolution = iSolution;
            this.currentCompanions = hashMap;
        }

        public double getNodeVoltage(int n) {
            return this.mnaSolution.getNodeVoltage(n);
        }

        public double getCurrent(LinearCircuitSolver.Element element) {
            if (this.currentCompanions.containsKey(element)) {
                return this.currentCompanions.get(element).getValue(this.mnaSolution);
            }
            return this.mnaSolution.getCurrent(element);
        }

        public String toString() {
            return "DynamicCircuitSolution{circuit=" + this.circuit + ", mnaSolution=" + this.mnaSolution + ", currentCompanions=" + this.currentCompanions + '}';
        }

        public double getVoltage(LinearCircuitSolver.Element element) {
            return this.getNodeVoltage(element.node1) - this.getNodeVoltage(element.node0);
        }
    }

    public static class DynamicElementState {
        private double voltage;
        private double current;

        public DynamicElementState(double d, double d2) {
            this.current = d2;
            this.voltage = d;
        }

        public String toString() {
            return "CState{voltage=" + this.voltage + ", current=" + this.current + '}';
        }
    }

    public static class DynamicInductor {
        private Inductor inductor;
        private DynamicElementState state;

        public DynamicInductor(Inductor inductor, DynamicElementState dynamicElementState) {
            this.inductor = inductor;
            this.state = dynamicElementState;
        }

        public double getCurrent() {
            return this.state.current;
        }

        public Inductor getInductor() {
            return this.inductor;
        }

        public String toString() {
            return "DynamicInductor{inductor=" + this.inductor + ", state=" + this.state + '}';
        }
    }

    public class DynamicState {
        private final DynamicCircuit circuit;
        private final DynamicCircuitSolution solution;

        DynamicState(DynamicCircuit dynamicCircuit2, DynamicCircuitSolution dynamicCircuitSolution) {
            this.circuit = dynamicCircuit2;
            this.solution = dynamicCircuitSolution;
        }

        DynamicState update(double d) {
            DynamicCircuitSolution dynamicCircuitSolution = this.circuit.solvePropagate(d);
            DynamicCircuit dynamicCircuit = this.circuit.updateCircuit(dynamicCircuitSolution);
            return new DynamicState(dynamicCircuit, dynamicCircuitSolution);
        }

        public DynamicCircuitSolution getSolution() {
            return this.solution;
        }

        public String toString() {
            return "DynamicState{circuit=" + this.circuit + ", solution=" + this.solution + '}';
        }
    }

    public static class Inductor
    extends LinearCircuitSolver.Element {
        double inductance;

        public Inductor(int n, int n2, double d) {
            super(n, n2);
            this.inductance = d;
        }
    }

    public static class ResistiveBattery
    extends LinearCircuitSolver.Element {
        private double voltage;
        private double resistance;

        public ResistiveBattery(int n, int n2, double d, double d2) {
            super(n, n2);
            this.resistance = d2;
            this.voltage = d;
        }

        public String toString() {
            return "ResistiveBattery{resistance=" + this.resistance + ", voltage=" + this.voltage + '}';
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Result {
        LinearCircuitSolver.Circuit mnaCircuit;
        HashMap<LinearCircuitSolver.Element, SolutionToDouble> currentCompanions;

        Result(LinearCircuitSolver.Circuit circuit, HashMap<LinearCircuitSolver.Element, SolutionToDouble> hashMap) {
            this.mnaCircuit = circuit;
            this.currentCompanions = hashMap;
        }
    }

    static interface SolutionToDouble {
        public double getValue(LinearCircuitSolver.ISolution var1);
    }
}

